function F = myfun(x,c,itype)
% % Example 1:
% c = -1; % define parameter first
% [x, feval_x, exitflag] = fsolve(@(x) myfun(x,c,1),[-5 -5])
%
% % Example 2:
% [x, feval_x, exitflag] = fsolve(@(x) myfun(x,[],2),[0 0])
%
% % Example 3: (incompatible system)
% [x, feval_x, exitflag] = fsolve(@(x) myfun(x,[],3),[0 0])


switch itype
    case 1
        F = [ 2*x(1) - x(2) - exp(c*x(1));
            -x(1) + 2*x(2) - exp(c*x(2))];
    case 2
        F = [exp(-exp(-(x(1)+x(2)))) - x(2)*(1+x(1)^2);
            x(1)*cos(x(2)) + x(2)*sin(x(1)) - 0.5];
    case 3
        F = [2*(x(1) - 3); 2*x(1) + sin(x(2))];
        
    case 4
        
        
            
        
            % x(1) is [5HT]
            % x(2) is [DA]
            y(1)=exp(-10*(x(1)-0.1)); 
            y(2)=exp(-10*(x(2)-0.1)); 
            
            
            
            F1 = 16.25*x(1)/(0.17+x(1)) + c(7)*(80/(1+y(1))) - (0.03/(1+c(8)*y(2)^2))*((c(9)*c(7) + c(1)*c(10)*c(11) + c(2)*c(12)*c(13) + c(3)*c(14)*c(15))) - ...
                (0.03/(1+y(1)^2))*((c(1)*c(10)*c(16) + c(2)*c(12)*c(13) + c(3)*c(14)*c(17))) - ...
                c(7)*(99.87 + c(20)) - c(1)*c(10)*(100 + c(21)) - c(2)*c(12)*(200+c(22)) - c(3)*c(14)*(450+c(23));
            F2 = 40*x(2)/(0.15+x(2)) + c(18)*(80/(1+y(2))) - (0.03/(1+y(1)^2))*((-c(13)*c(18) + c(4)*c(10)*c(16)) + c(5)*c(12)*c(13) + c(6)*c(14)*c(17)) ...
                -(0.03/(1+c(8)*y(2)^2))*((c(4)*c(10)*c(11) + c(5)*c(12)*c(19) + c(6)*c(14)*c(15))) ...
                -c(18)*(210+c(24)) - c(4)*(100+c(21))*c(10) - c(5)*(200+c(22))*c(12) - c(6)*(450+c(23))*c(14);
            
            F = [F1; F2];
                        
       
        
    case 5  
        
            % x(1) is [5HT]
            % x(2) is [DA]
            y(1)=exp(-10*(x(1)-0.1)); 
            y(2)=exp(-10*(x(2)-0.1)); 
            
            F1 = 16.25*x(1)/(0.17+x(1)) -( c(7)*(-80/(1+y(1))+0.03*c(9)/(1+c(8)*y(2)^2)+99.87+c(20))+...
                c(1)*(0.03*c(16)*c(10)/(1+y(1)^2)+...
                0.03*c(11)*c(10)/(1+c(8)*y(2)^2)+c(10)*(100+c(21)))+...
                c(2)*(0.03*c(34)*c(12)/(1+y(1)^2)+0.03*c(9)*c(12)*c(33)/(1+c(8)*y(2)^2)-80*c(33)*c(12)*c(7)/(1+y(1))+...
                c(33)*c(12)*(99.87+c(20))+200+c(22))+c(3)*(0.03*c(17)*c(14)/(1+y(1)^2)+...
                0.03*c(15)*c(14)/(1+c(8)*y(2)^2)+c(14)*(450+c(23))));
            F2 = 40*x(2)/(0.15+x(2))-( c(18)*(-0.03*c(9)*c(32)/(1+c(8)*y(2))^2-80/(1+y(2))+...
                80*c(32)/(1+y(1)+210+c(24)-c(32)*(99.87+c(20))))+c(4)*(0.03*c(16)*c(10)/(1+y(1)^2)+...
                0.03*c(11)*c(10)/(1+c(8)*y(2)^2)+c(10)*(100+c(21)))+...
                c(5)*(0.03*c(34)*c(12)/(1+y(1)^2)+0.03*c(9)*c(12)*c(33)/(1+c(8)*y(2)^2)-80*c(33)*c(12)*c(7)/(1+y(1))+...
                c(33)*c(12)*(99.87+c(20))+200+c(22))+c(6)*(0.03*c(17)*c(14)/(1+y(1)^2)+...
                0.03*c(15)*c(14)/(1+c(8)*y(2)^2)+c(14)*(450+c(23))));
            
            F = [F1; F2];
        
        
end